"use client";

import { useEffect, useState } from "react";

import "../public/scss/main.scss";
import "photoswipe/dist/photoswipe.css";
import "rc-slider/assets/index.css";
import HomesModal from "@/components/modals/HomesModal";
import Context from "@/context/Context";
import QuickView from "@/components/modals/QuickView";
import ProductSidebar from "@/components/modals/ProductSidebar";
import QuickAdd from "@/components/modals/QuickAdd";
import Compare from "@/components/modals/Compare";
import ShopCart from "@/components/modals/ShopCart";
import AskQuestion from "@/components/modals/AskQuestion";
import BlogSidebar from "@/components/modals/BlogSidebar";
import ColorCompare from "@/components/modals/ColorCompare";
import DeliveryReturn from "@/components/modals/DeliveryReturn";
import FindSize from "@/components/modals/FindSize";
import Login from "@/components/modals/Login";
import MobileMenu from "@/components/modals/MobileMenu";
import Register from "@/components/modals/Register";
import ResetPass from "@/components/modals/ResetPass";
import SearchModal from "@/components/modals/SearchModal";
import ToolbarBottom from "@/components/modals/ToolbarBottom";
import ToolbarShop from "@/components/modals/ToolbarShop";

import { usePathname } from "next/navigation";
import ScrollTop from "@/components/common/ScrollTop";
import Header4 from "@/components/headers/Header4";
import Footer1 from "@/components/footers/Footer1";

import { ToastContainer } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";

export default function RootLayout({ children }) {
     const pathname = usePathname();
     useEffect(() => {
          if (typeof window !== "undefined") {
               import("bootstrap/dist/js/bootstrap.esm").then(() => {
                    // Module is imported, you can access any exported functionality if
               });
          }
     }, []);

     useEffect(() => {
          const handleScroll = () => {
               const header = document.querySelector("header");
               if (window.scrollY > 100) {
                    header.classList.add("header-bg");
               } else {
                    header.classList.remove("header-bg");
               }
          };

          window.addEventListener("scroll", handleScroll);

          return () => {
               window.removeEventListener("scroll", handleScroll);
          };
     }, []); 

     const [scrollDirection, setScrollDirection] = useState("down");

     useEffect(() => {
          setScrollDirection("up");
          const handleScroll = () => {
               const currentScrollY = window.scrollY;

               if (currentScrollY > 250) {
                    if (currentScrollY > lastScrollY.current) {
                         setScrollDirection("down");
                    } else {
                         setScrollDirection("up");
                    }
               } else {
                    setScrollDirection("down");
               }

               lastScrollY.current = currentScrollY;
          };

          const lastScrollY = { current: window.scrollY };

          window.addEventListener("scroll", handleScroll);

          return () => {
               window.removeEventListener("scroll", handleScroll);
          };
     }, [pathname]);

     useEffect(() => {
        
          const bootstrap = require("bootstrap"); 
          const modalElements = document.querySelectorAll(".modal.show");
          modalElements.forEach((modal) => {
               const modalInstance = bootstrap.Modal.getInstance(modal);
               if (modalInstance) {
                    modalInstance.hide();
               }
          });

          // Close any open offcanvas
          const offcanvasElements =
               document.querySelectorAll(".offcanvas.show");
          offcanvasElements.forEach((offcanvas) => {
               const offcanvasInstance =
                    bootstrap.Offcanvas.getInstance(offcanvas);
               if (offcanvasInstance) {
                    offcanvasInstance.hide();
               }
          });
     }, [pathname]);

     useEffect(() => {
          const header = document.querySelector("header");
          if (header) {
               if (scrollDirection == "down") {
                    header.style.top = "0px";
               } else {
                    header.style.top = "-185px";
               }
          }
     }, [scrollDirection]);
     
     useEffect(() => {
          const { WOW } = require("wowjs");
          const wow = new WOW({
               mobile: false,
               live: false,
          });
          wow.init();
     }, [pathname]);

     useEffect(() => {
          const initializePreloader = () => {
               document.documentElement.dir = "ltr";
          
               const preloader = document.getElementById("preloader");
               if (preloader) {
                    preloader.classList.add("disabled");
               }
          };

          initializePreloader();
     }, []); 

     return (
          <html lang="ro" dir="ltr">
               <body className="preload-wrapper" dir="ltr">
                    <div className="preload preload-container" id="preloader">
                         <div className="preload-logo">
                              <div className="spinner"></div>
                         </div>
                    </div>{" "}
                    <Context>
                         <Header4/>
                         <ToastContainer />
                         <div id="wrapper">{children}</div>
                         <HomesModal /> 
                         <QuickView />
                         <QuickAdd />
                         <ProductSidebar />
                         <Compare />
                         <ShopCart />
                         <AskQuestion />
                         <BlogSidebar />
                         <ColorCompare />
                         <DeliveryReturn />
                         <FindSize />
                         <Login />
                         <MobileMenu />
                         <Register />
                         <ResetPass />
                         <SearchModal />
                         <ToolbarBottom />
                         <ToolbarShop />
                         
                         <Footer1/> 
                    </Context>
                    <ScrollTop />
               </body>
          </html>
     );
}
