"use client";
import { Pagination } from "swiper/modules";
import { Swiper, SwiperSlide } from "swiper/react";

export default function Features() {
  return (
    <section className="flat-spacing-27">
      <div className="container">
        <div className="flat-iconbox-v3">
          <div className="wrap-carousel wrap-mobile">
            <Swiper
              dir="ltr"
              modules={[Pagination]}
              pagination={{ clickable: true, el: ".spd231" }}
              breakpoints={{
                768: { slidesPerView: 3, spaceBetween: 15 },
                480: { slidesPerView: 2, spaceBetween: 15 },
                0: { slidesPerView: 1, spaceBetween: 15 },
              }}
              className="swiper tf-sw-mobile"
              spaceBetween={15}
            >
              <SwiperSlide className="swiper-slide">
                <div className="tf-icon-box small text-center">
                  <div className="icon w-40 no-border">
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="40"
                      height="29"
                      viewBox="0 0 40 29"
                      fill="none"
                    >
                      <path
                        d="M0.545252 15.2485C2.9115 17.2781 5.59338 19.5787 10.781 19.5787C15.9687 19.5786 18.6507 17.2781 21.017 15.2485C23.2549 13.3291 25.1875 11.6714 29.2186 11.6714C33.2498 11.6714 35.1824 13.3291 37.4202 15.2485C38.0753 15.8103 39.0617 15.7348 39.6235 15.0798C40.1853 14.4248 40.1098 13.4384 39.4547 12.8766C37.0884 10.847 34.4063 8.54641 29.2186 8.54641C24.0309 8.54641 21.3488 10.8469 18.9825 12.8766C16.7447 14.7959 14.8121 16.4537 10.781 16.4537C6.74994 16.4537 4.81752 14.796 2.57986 12.8766C1.92486 12.3148 0.938455 12.3902 0.37658 13.0452C-0.185295 13.7002 -0.109748 14.6867 0.545252 15.2485Z"
                        fill="#67C08F"
                      ></path>
                      <path
                        d="M0.545252 6.70211C2.91142 8.7318 5.5933 11.0323 10.781 11.0323C15.9687 11.0323 18.6507 8.7318 21.017 6.70211C23.2549 4.78273 25.1874 3.125 29.2186 3.125C33.2496 3.125 35.1823 4.78266 37.4202 6.70211C38.0753 7.26406 39.0616 7.18836 39.6234 6.53328C40.1853 5.87828 40.1096 4.89172 39.4546 4.33C37.0882 2.30031 34.4062 0 29.2186 0C24.0309 0 21.3488 2.30047 18.9825 4.33016C16.7447 6.24953 14.8121 7.90727 10.781 7.90727C6.75002 7.90727 4.81752 6.24961 2.57986 4.33016C1.92486 3.76828 0.938377 3.84375 0.37658 4.49883C-0.185295 5.15383 -0.109748 6.14031 0.545252 6.70211ZM39.4547 21.4229C37.0884 19.3933 34.4063 17.0927 29.2186 17.0927C24.0309 17.0927 21.3488 19.3932 18.9825 21.4229C16.7447 23.3423 14.8121 25 10.781 25C6.75017 25 4.8176 23.3423 2.57994 21.423L2.57978 21.4229C1.92478 20.8613 0.938455 20.9367 0.37658 21.5916C-0.185217 22.2466 -0.10967 23.2331 0.54533 23.7949C2.91158 25.8246 5.59353 28.125 10.781 28.125C15.9687 28.125 18.6507 25.8245 21.017 23.7948C23.2549 21.8755 25.1875 20.2177 29.2186 20.2177C33.2498 20.2177 35.1824 21.8755 37.4202 23.7948C38.0753 24.3566 39.0617 24.2812 39.6235 23.6262C40.1853 22.9711 40.1098 21.9847 39.4547 21.4229Z"
                        fill="#67C08F"
                      ></path>
                    </svg>
                  </div>
                  <div className="content">
                    <div className="title">Protects Our Oceans</div>
                    <p>
                      Pela donates a % of every sale to Ocean Cleanup <br />
                      and Preservation Initiatives.
                    </p>
                  </div>
                </div>
              </SwiperSlide>
              <SwiperSlide className="swiper-slide">
                <div className="tf-icon-box small text-center">
                  <div className="icon w-40 no-border">
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="40"
                      height="40"
                      viewBox="0 0 40 40"
                      fill="none"
                    >
                      <path
                        d="M36.7273 14.5455C36 14.5455 35.2727 14.1818 35.0909 13.4545C32.3636 7.45455 26.5455 3.63636 20 3.63636C13.4545 3.63636 7.63636 7.45455 4.90909 13.4545C4.54545 14.3636 3.45455 14.7273 2.54545 14.3636C1.63636 14 1.27273 12.9091 1.63636 12C4.90909 4.72727 12 0 20 0C28 0 35.0909 4.72727 38.3636 12C38.7273 12.9091 38.3636 14 37.4545 14.3636C37.0909 14.5455 36.9091 14.5455 36.7273 14.5455Z"
                        fill="#67C08F"
                      ></path>
                      <path
                        d="M20 40C18.9091 40 18.1818 39.2727 18.1818 38.1818C18.1818 33.8182 16.3636 29.6364 13.2727 26.5455C13.0909 26.1818 12.7273 25.8182 12.7273 25.4545V24C12.7273 18.5455 14.9091 13.4545 18.7273 9.63636C19.4545 8.90909 20.5455 8.90909 21.2727 9.63636C25.0909 13.4545 27.2727 18.5455 27.2727 24V25.4545C27.2727 25.8182 27.0909 26.3636 26.7273 26.5455C23.6364 29.6364 21.8182 33.8182 21.8182 38.1818C21.8182 39.2727 21.0909 40 20 40ZM16.3636 24.5455C17.8182 26.1818 19.0909 28 20 29.8182C20.9091 27.8182 22.1818 26 23.6364 24.5455V24C23.6364 20.1818 22.3636 16.5455 20 13.6364C17.6364 16.5455 16.3636 20.1818 16.3636 24V24.5455Z"
                        fill="#67C08F"
                      ></path>
                      <path
                        d="M20 40C8.90909 40 0 31.0909 0 20C0 18.9091 0.727273 18.1818 1.81818 18.1818C7.09091 18.1818 12.1818 20.1818 15.8182 24C19.6364 27.8182 21.8182 32.7273 21.8182 38.1818C21.8182 39.2727 21.0909 40 20 40ZM3.81818 22C4.72727 29.4545 10.7273 35.4545 18.1818 36.3636C17.8182 32.7273 16.1818 29.2727 13.4545 26.7273C10.7273 24 7.27273 22.3636 3.81818 22Z"
                        fill="#67C08F"
                      ></path>
                      <path
                        d="M20 40C18.9091 40 18.1818 39.2727 18.1818 38.1818C18.1818 32.7273 20.3636 27.8182 24.1818 24C28 20.3636 32.9091 18.1818 38.1818 18.1818C39.2727 18.1818 40 18.9091 40 20C40 31.0909 31.0909 40 20 40ZM36.1818 22C32.5455 22.3636 29.2727 24 26.5455 26.5455C23.8182 29.2727 22.1818 32.5455 21.8182 36.1818C29.4545 35.4545 35.4545 29.4545 36.1818 22Z"
                        fill="#67C08F"
                      ></path>
                    </svg>
                  </div>
                  <div className="content">
                    <div className="title">Inspired by Plants</div>
                    <p>
                      Made from flax shive and a plant based biopolymer
                      <br />
                      create the base for our compostable cases.
                    </p>
                  </div>
                </div>
              </SwiperSlide>
              <SwiperSlide className="swiper-slide">
                <div className="tf-icon-box small text-center">
                  <div className="icon w-40 no-border">
                    <svg
                      xmlns="http://www.w3.org/2000/svg"
                      width="40"
                      height="40"
                      viewBox="0 0 40 40"
                      fill="none"
                    >
                      <path
                        fillRule="evenodd"
                        clipRule="evenodd"
                        d="M20 3.63636C17.8511 3.63636 15.7232 4.05962 13.7379 4.88197C11.7526 5.70432 9.94867 6.90966 8.42916 8.42916C6.90966 9.94867 5.70432 11.7526 4.88197 13.7379C4.05962 15.7232 3.63636 17.8511 3.63636 20C3.63636 22.1489 4.05962 24.2768 4.88197 26.2621C5.70432 28.2474 6.90966 30.0513 8.42916 31.5708C9.94867 33.0903 11.7526 34.2957 13.7379 35.118C15.7232 35.9404 17.8511 36.3636 20 36.3636C24.3399 36.3636 28.5021 34.6396 31.5708 31.5708C34.6396 28.5021 36.3636 24.3399 36.3636 20C36.3636 15.6601 34.6396 11.4979 31.5708 8.42916C28.5021 5.36038 24.3399 3.63636 20 3.63636ZM0 20C0 8.95455 8.95455 0 20 0C31.0455 0 40 8.95455 40 20C40 31.0455 31.0455 40 20 40C8.95455 40 0 31.0455 0 20ZM10.9091 15.4545C10.9091 14.7312 11.1964 14.0375 11.7079 13.5261C12.2194 13.0146 12.913 12.7273 13.6364 12.7273C14.3597 12.7273 15.0534 13.0146 15.5648 13.5261C16.0763 14.0375 16.3636 14.7312 16.3636 15.4545C16.3636 16.1779 16.0763 16.8716 15.5648 17.383C15.0534 17.8945 14.3597 18.1818 13.6364 18.1818C12.913 18.1818 12.2194 17.8945 11.7079 17.383C11.1964 16.8716 10.9091 16.1779 10.9091 15.4545ZM23.6364 15.4545C23.6364 14.7312 23.9237 14.0375 24.4352 13.5261C24.9466 13.0146 25.6403 12.7273 26.3636 12.7273C27.087 12.7273 27.7806 13.0146 28.2921 13.5261C28.8036 14.0375 29.0909 14.7312 29.0909 15.4545C29.0909 16.1779 28.8036 16.8716 28.2921 17.383C27.7806 17.8945 27.087 18.1818 26.3636 18.1818C25.6403 18.1818 24.9466 17.8945 24.4352 17.383C23.9237 16.8716 23.6364 16.1779 23.6364 15.4545ZM11.9145 23.8291C12.3457 23.6138 12.8447 23.5784 13.3018 23.7308C13.759 23.8832 14.137 24.2109 14.3527 24.6418C14.6655 25.2655 16.3545 27.2727 20 27.2727C23.6455 27.2727 25.3345 25.2655 25.6473 24.6418C25.7494 24.4208 25.8949 24.2225 26.0751 24.0587C26.2553 23.895 26.4665 23.7691 26.6963 23.6885C26.9261 23.6079 27.1697 23.5744 27.4127 23.5897C27.6557 23.6051 27.8932 23.6692 28.111 23.7781C28.3288 23.887 28.5225 24.0385 28.6806 24.2237C28.8387 24.4088 28.958 24.6239 29.0314 24.8561C29.1048 25.0882 29.1309 25.3328 29.108 25.5752C29.0851 25.8176 29.0138 26.053 28.8982 26.2673C28 28.0673 25.0818 30.9091 20 30.9091C14.9182 30.9091 12 28.0673 11.1018 26.2673C10.8865 25.8361 10.8512 25.3372 11.0036 24.88C11.156 24.4228 11.4836 24.0448 11.9145 23.8291Z"
                        fill="#67C08F"
                      ></path>
                    </svg>
                  </div>
                  <div className="content">
                    <div className="title">100% Happiness Guarantee</div>
                    <p>
                      Enjoy free shipping worldwide, fast and secure checkout,{" "}
                      <br />
                      and hassle-free exchange and returns.
                    </p>
                  </div>
                </div>
              </SwiperSlide>
            </Swiper>
            <div className="sw-dots style-2 sw-pagination-mb justify-content-center spd231"></div>
          </div>
        </div>
      </div>
    </section>
  );
}
