"use client";
import React from "react";
import Link from "next/link";

import { useForm } from 'react-hook-form';
import { userService } from '@/services/user.service';

// Toast Notification
import { toast } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";

import { checkIsLogged } from "../../utlis/authCheck"; 

export default function Login() {
     checkIsLogged("/"); 

     const { register, handleSubmit, formState: { errors }, watch } = useForm();

     const onSubmit = async (data) => {
		const userEmail = data.email;
		const userPass = data.password;

		try {
			await userService.login(userEmail, userPass);
			window.location.href = "/";
		} catch (error) {
			toast.error(error); 
		}
	};

	return (
		<section className='flat-spacing-10'>
			<div className='container'>
				<div className='tf-grid-layout lg-col-2 tf-login-wrap'>
					<div className='tf-login-form'>
						<div id='recover'>
							<h5 className='mb_24'>
								Reseteaza parola 
							</h5>
							<p className='mb_30'>
								We will send you an email to reset your
								password
							</p>
							<div>
								<form
									onSubmit={(e) =>
										e.preventDefault()
									}
									className=''
								>
									<div className='tf-field style-1 mb_15'>
										<input
											className='tf-field-input tf-input'
											placeholder=''
											required
											type='email'
											autoComplete='abc@xyz.com'
											id='property3'
											name='email'
                                                       {...register("email", {
                                                            required: true,
                                                            pattern: /^\S+@\S+$/i,
                                                       })}
										/>
										<label
											className='tf-field-label fw-4 text_black-2'
											htmlFor='property3'
										>
											Email *
										</label>
                                                  {errors.email && (
                                                       <span className='error'>
                                                            Trebuie sa introduci o adresa
                                                            de email valida.
                                                       </span>
                                                  )}
									</div>
									<div className='mb_20'>
										<a
											href='#login'
											className='tf-btn btn-line'
										>
											Cancel
										</a>
									</div>
									<div className=''>
										<button
											type='submit'
											className='tf-btn w-100 radius-3 btn-fill animate-hover-btn justify-content-center'
										>
											Reset password
										</button>
									</div>
								</form>
							</div>
						</div>
						<div id='login'>
							<h5 className='mb_36'>Autentificare</h5>
							<div>
								<form
									onSubmit={handleSubmit(onSubmit)}
								>
									<div className='tf-field style-1 mb_15'>
										<input
											required
											className='tf-field-input tf-input'
											placeholder=''
											type='email'
											autoComplete='abc@xyz.com'
											id='property3'
											name='email'
                                                       {...register("email", {
                                                            required: true,
                                                            pattern: /^\S+@\S+$/i,
                                                       })}
										/>
										<label
											className='tf-field-label fw-4 text_black-2'
											htmlFor='property3'
										>
											Email *
										</label>
									</div>
									<div className='tf-field style-1 mb_30'>
										<input
											required
											className='tf-field-input tf-input'
											placeholder=''
											type='password'
											id='property4'
											name='password'
											autoComplete='current-password'
                                                       {...register('password', { required: true })} 
										/>
										<label
											className='tf-field-label fw-4 text_black-2'
											htmlFor='property4'
										>
											Parola *
										</label>
									</div>
									<div className='mb_20'>
										<a
											href='#recover'
											className='tf-btn btn-line'
										>
											Ti-ai uitat parola ?
										</a>
									</div>
									<div className=''>
										<button
											type='submit'
											className='tf-btn w-100 radius-3 btn-fill animate-hover-btn justify-content-center'
										>
											Autentificare
										</button>
									</div>
								</form>
							</div>
						</div>
					</div>
					<div className='tf-login-content'>
						<h5 className='mb_36'>Nu ai cont?</h5>
						<p className='mb_20'>
                                   Nu-ți face griji!
                                   Poți crea unul în pasul următor.
						</p>
						<Link
							href={`/inregistrare`}
							className='tf-btn btn-line'
						>
							Inregistrare
							<i className='icon icon-arrow1-top-left' />
						</Link>
					</div>
				</div>
			</div>
		</section>
	);
}
