"use client";
import { useState } from "react";
import Sidebar from "./Sidebar";
import ProductGrid from "./ProductGrid";
import Pagination from "../common/Pagination";
import Sorting from "./Sorting";
import { products1 } from "@/data/products";

export default function ShopSidebarleft() {
	const [gridItems, setGridItems] = useState(4);
	const [finalSorted, setFinalSorted] = useState([]);
	return (
		<>
			<section className="flat-spacing-1">
				<div className="container">
					<div className="tf-shop-control grid-3 align-items-center">
						<div className="tf-control-filter"></div>
						<ul className="tf-control-layout d-flex justify-content-center">
							
						</ul>
						<div className="tf-control-sorting d-flex justify-content-end">
							<div
								className="tf-dropdown-sort"
								data-bs-toggle="dropdown"
							>
								<Sorting
									setFinalSorted={setFinalSorted}
									products={products1}
								/>
							</div>
						</div>
					</div>
					<div className="tf-row-flex">
						<Sidebar />
						<div className="tf-shop-content">
							<ProductGrid
								allproducts={finalSorted}
								gridItems={gridItems}
							/>
							{/* pagination */}{" "}
							{finalSorted.length ? (
								<ul className="tf-pagination-wrap tf-pagination-list">
									<Pagination />
								</ul>
							) : (
								""
							)}
						</div>
					</div>
				</div>
			</section>
			<div className="btn-sidebar-style2">
				<button
					data-bs-toggle="offcanvas"
					data-bs-target="#sidebarmobile"
					aria-controls="offcanvas"
				>
					<i className="icon icon-sidebar-2" />
				</button>
			</div>
		</>
	);
}
