import { db } from "@/helpers/api/db";

export default async function handler(req, res) {
	if (!db.initialized) {
		await db.initialize();
	}

	try {
		const getParents = await db.Categories.findAll({
               where: { parentID: 0 },
               limit: 5,
               raw:false
          });

		return res.status(200).json({ categories: getParents });
	} catch (error) {
		console.error("Error fetching categories:", error);
		return res
			.status(500)
			.json({ error: "Internal server error", status: 500 });
	}
}
