import { db } from "@/helpers/api/db";

export default async function handler(req, res) {
     if (!db.initialized) {
          await db.initialize();
     }

     try {
          const { ids } = req.query; 
          if (!ids || !/^\d+(,\d+)*$/.test(ids)) {
               return res.status(400).json({ error: "Invalid request" });
          }

          const idList = ids.split(",").map(Number);

          const wishlistProducts = await db.Products.findAll({
               where: { id: idList }, 
               raw: true, 
          }); 

          return res.status(200).json({ wishlistProducts });
     } catch (error) {
          console.error("Error fetching categories:", error);
          return res
               .status(500)
               .json({ error: "Internal server error", status: 500 });
     }
}
