import { apiHandler, db } from '@/helpers/api';

export default apiHandler({
     get: getUserData,
     delete: deleteUser, 
     post: updateUserData
});

async function getUserData(req, res) {
     const userID = req.userID;

     if(!db.initialized)
          await db.initialize(); 

     try {
          const userData = await db.User.findByPk(userID); 
          
          if (!userData) 
               return res.status(404).json({ error: 'Unknown!' });

          if(userData.admin == 0) 
               return res.status(401).json({error:'Not authorized'}); 

          const responseArray = [];

          const studentCount = await db.User.count({
               where: {
                    accountType: 0 
               }
          });

          const instructorCount = await db.User.count({
               where: {
                    accountType: 1 
               }
          });  

          const courseCount = await db.Courses.count();
          const courseCountWaiting = await db.Courses.count({
               where: {
                    waiting: 1 
               }
          });

          responseArray.push({
               studentCount: studentCount, 
               instructorCount: instructorCount, 
               courseCount: courseCount, 
               courseCountWaiting: courseCountWaiting, 
          });

          return res.status(200).json(responseArray);
     } catch (error) {
          return res.status(500).json({ error: 'Eroare la preluarea datelor utilizatorului.' });
     }
}

async function deleteUser(req, res) {
     const userID = req.userID;
     const { userDeleteID } = req.body;

     if(!db.initialized)
          await db.initialize(); 

     try {
          const userData = await db.User.findByPk(userID); 
          
          if (!userData) 
               return res.status(404).json({ error: 'Unknown!' });

          if(userData.admin == 0) 
               return res.status(401).json({error:'Not authorized'}); 

          const responseArray = [];

          await db.User.delete({
               where: {
                    id: userDeleteID
               }
          });

          responseArray.push({ message: 'Utilizatorul a fost sters. '});

          return res.status(200).json(responseArray);
     } catch (error) {
          return res.status(500).json({ error: 'Eroare la preluarea datelor utilizatorului.' });
     }
}

async function updateUserData(req, res) {
     const userID = req.userID;
     const { updatedData, userUpdatedID } = req.body;

     if(!db.initialized)
          await db.initialize(); 

     try {
          const userData = await db.User.findByPk(userID); 
          
          if (!userData) 
               return res.status(404).json({ error: 'Unknown!' });

          if(userData.admin == 0) 
               return res.status(401).json({error:'Not authorized'}); 

          const responseArray = [];

          await db.User.update(
               updatedData, 
               {
                   where: {
                       id: userUpdatedID
                   }
               }
          );

          responseArray.push({ message: 'Utilizatorul a fost actualizat. '});

          return res.status(200).json(responseArray);
     } catch (error) {
          return res.status(500).json({ error: 'Eroare la preluarea datelor utilizatorului.' });
     }
}