import { toast } from 'react-toastify';
import { BehaviorSubject } from 'rxjs';

const alertSubject = new BehaviorSubject(null);

export const alertService = {
    alert: alertSubject.asObservable(),
    success,
    error,
    clear
};

function success(message, showAfterRedirect = false) {
     toast.success(message); 
}

function error(message) {
     toast.error(message); 
}

function clear() { }