"use client";
import React, { useEffect, useRef, useState } from "react";
import Image from "next/image";
import Link from "next/link";
import LanguageSelect from "../common/LanguageSelect";
import CurrencySelect from "../common/CurrencySelect";
import emailjs from "@emailjs/browser";
import { aboutLinks, footerLinks, paymentImages } from "@/data/footerLinks";
export default function Footer1({ bgColor = "" }) {
	useEffect(() => {
		const headings = document.querySelectorAll(".footer-heading-moblie");

		const toggleOpen = (event) => {
			const parent = event.target.closest(".footer-col-block");

			parent.classList.toggle("open");
		};

		headings.forEach((heading) => {
			heading.addEventListener("click", toggleOpen);
		});

		// Clean up event listeners when the component unmounts
		return () => {
			headings.forEach((heading) => {
				heading.removeEventListener("click", toggleOpen);
			});
		};
	}, []); // Empty dependency array means this will run only once on mount

	const formRef = useRef();
	const [success, setSuccess] = useState(true);
	const [showMessage, setShowMessage] = useState(false);

	const handleShowMessage = () => {
		setShowMessage(true);
		setTimeout(() => {
			setShowMessage(false);
		}, 2000);
	};

	const sendMail = (e) => {
		emailjs
			.sendForm(
				"service_noj8796",
				"template_fs3xchn",
				formRef.current,
				{
					publicKey: "iG4SCmR-YtJagQ4gV",
				}
			)
			.then((res) => {
				if (res.status === 200) {
					setSuccess(true);
					handleShowMessage();
					formRef.current.reset();
				} else {
					setSuccess(false);
					handleShowMessage();
				}
			});
	};

	return (
		<footer id='footer' className={`footer md-pb-70 ${bgColor}`}>
			<div className='footer-wrap'>
				<div className='footer-body'>
					<div className='container'>
						<div className='row'>
							<div className='col-xl-3 col-md-6 col-12'>
								<div className='footer-infor'>
									<div className='footer-logo'>
										<Link href={`/`}>
											<Image
												alt='image'
												src='/images/logo/emagyl.png'
												width='136'
												height='21'
											/>
										</Link>
									</div>
									<ul>
										<li>
											<p>
												Adresa: ... 
											</p>
										</li>
										<li>
											<p>
												Email: contact@emagyl.ro
											</p>
										</li>
										<li>
											<p>
												Telefon: ... 
											</p>
										</li>
									</ul>
				
									
								</div>
							</div>
							<div className='col-xl-3 col-md-6 col-12 footer-col-block'>
								<div className='footer-heading footer-heading-desktop'>
									<h6>eMagyl.Ro</h6>
								</div>
								<div className='footer-heading footer-heading-moblie'>
									<h6>eMagyl.Ro</h6>
								</div>
								<ul className='footer-menu-list tf-collapse-content'>
									{footerLinks.map((link, index) => (
										<li key={index}>
											<Link
												href={link.href}
												className='footer-menu_item'
											>
												{link.text}
											</Link>
										</li>
									))}
								</ul>
							</div>
							<div className='col-xl-3 col-md-6 col-12 footer-col-block'>
                                        <div className='footer-heading footer-heading-desktop'>
									<h6>Suport clienti</h6>
								</div>
								<div className='footer-heading footer-heading-moblie'>
									<h6>Suport clienti</h6>
								</div>
                                        <ul className='footer-menu-list tf-collapse-content'>
									{aboutLinks.map((link, index) => (
										<li key={index}>
											<Link
												href={link.href}
												className='footer-menu_item'
											>
												{link.text}
											</Link>
										</li>
									))}
								</ul>
							</div>
                                   
							<div className='col-xl-3 col-md-6 col-12'>
								<div className='footer-newsletter footer-col-block'>
									<div className='footer-heading footer-heading-desktop'>
										<h6>Inscrie-te la Newsletter</h6>
									</div>
									<div className='footer-heading footer-heading-moblie'>
										<h6>Inscrie-te la Newsletter</h6>
									</div>
									<div className='tf-collapse-content'>
										<div className='footer-menu_item'>
                                                  Înscrieți-vă pentru a obține ofertele 
                                                  la noile produse si a fii la curent cu toate reducerile.
										</div>
										<div
											className={`tfSubscribeMsg ${
												showMessage
													? "active"
													: ""
											}`}
										>
											{success ? (
												<p
													style={{
														color: "rgb(52, 168, 83)",
													}}
												>
													Te-ai inregistrat cu success.
												</p>
											) : (
												<p
													style={{
														color: "red",
													}}
												>
													Oops, ceva nu a mers bine. 
												</p>
											)}
										</div>
										<form
											ref={formRef}
											onSubmit={(e) => {
												e.preventDefault();
												sendMail();
											}}
											className='form-newsletter subscribe-form'
											action='#'
											method='post'
											acceptCharset='utf-8'
											data-mailchimp='true'
										>
											<div className='subscribe-content'>
												<fieldset className='email'>
													<input
														required
														type='email'
														name='email-form'
														className='subscribe-email'
														placeholder='Introdu adresa de mail....'
														tabIndex={
															0
														}
														aria-required='true'
														autoComplete='abc@xyz.com'
													/>
												</fieldset>
												<div className='button-submit'>
													<button
														className='subscribe-button tf-btn btn-sm radius-3 btn-fill btn-icon animate-hover-btn'
														type='submit'
													>
														Inscrie-te
														<i className='icon icon-arrow1-top-left' />
													</button>
												</div>
											</div>
											<div className='subscribe-msg' />
										</form>
					
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div className='footer-bottom'>
					<div className='container'>
						<div className='row'>
							<div className='col-12'>
								<div className='footer-bottom-wrap d-flex gap-20 flex-wrap justify-content-between align-items-center'>
									<div className='footer-menu_item'>
										© {new Date().getFullYear()}{" "}
										eMagyl.Ro. Toate drepturile rezervate.
									</div>
									<div className='tf-payment'>
										{paymentImages.map(
											(image, index) => (
												<Image
													key={index}
													src={image.src}
													width={
														image.width
													}
													height={
														image.height
													}
													alt={image.alt}
												/>
											)
										)}
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</footer>
	);
}
