"use client";
import Link from "next/link";
import React, { useState, useEffect } from "react";
import { fetchWrapper } from "@/helpers";

export default function Nav() {
	const [isHovered, setIsHovered] = useState(false);
     const [categories, setCategories] = useState([]); 

     useEffect(() => {
          async function fetchCategories() {

               const response = await fetchWrapper.get(`/api/categories`);

               setCategories(response.categories); 
     
          };
          fetchCategories();

     }, []); 

	return (
		<>
			{" "}
			<li
				className="menu-item"
				onMouseEnter={() => setIsHovered(true)}
				onMouseLeave={() => setIsHovered(false)}
			>
				<Link
					href="/"
					className="item-link dropdown-toggle categoriesLink"
					id="categoriiDropdown"
				>
					<i
						className="icon icon-list"
						style={{ fontSize: 18 }}
					/>{" "}
					Categorii
				</Link>
				<ul
					className={`dropdown-menu ${isHovered ? "show" : ""}`}
					aria-labelledby="categoriiDropdown"
					style={{ marginTop: 10 }}
				>
                         {categories.length > 0 && (
                              categories.map((category, index) => (
                                   <li key={index}>
                                        <Link
                                             href={`/${category.slug}`}
                                             className="dropdown-item"
                                        >
                                             {category.name}
                                        </Link>
                                   </li>
                              ))
                         )}
					
				</ul>
			</li>
			<li className="menu-item">
				<Link href="/" className="item-link">
					<i
						className="icon icon-home"
						style={{ fontSize: 18 }}
					/>{" "}
					Acasă
				</Link>
			</li>
			<li className="menu-item">
				<Link href="#" className="item-link">
					<i
						className="icon icon-bag"
						style={{ fontSize: 18 }}
					/>{" "}
					Magazin
				</Link>
			</li>
			<li className="menu-item">
				<Link href="#" className="item-link">
					<i
						className="icon icon-mail"
						style={{ fontSize: 16 }}
					></i>{" "}
					Contact
				</Link>
			</li>
		</>
	);
}
