"use client";

import { Pagination } from "swiper/modules";
import { Swiper, SwiperSlide } from "swiper/react";

export default function Features() {
  return (
    <section className="flat-spacing-9 flat-iconbox-v2">
      <div className="container">
        <div
          className="wrap-carousel wrap-mobile wow fadeInUp"
          data-wow-delay="0s"
        >
          <Swiper
            dir="ltr"
            className="swiper tf-sw-mobile"
            spaceBetween={30}
            slidesPerView={1}
            breakpoints={{
              640: { slidesPerView: 1 },
              768: { slidesPerView: 2 },
              1024: { slidesPerView: 3 },
            }}
            modules={[Pagination]}
            pagination={{ clickable: true, el: ".spd200" }}
          >
            <SwiperSlide className="swiper-slide">
              <div className="tf-icon-box text-center">
                <div className="icon">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width={50}
                    height={50}
                    viewBox="0 0 50 50"
                    fill="none"
                  >
                    <g clipPath="url(#clip0_10537_31)">
                      <path
                        d="M24.9994 9.22204C16.3003 9.22204 9.22292 16.2994 9.22292 24.9986C9.22292 33.6998 16.3003 40.7778 24.9994 40.7778C33.7006 40.7778 40.7787 33.6993 40.7787 24.9986C40.7787 16.2994 33.7002 9.22204 24.9994 9.22204ZM36.2433 18.7863H30.7625C30.5466 17.3045 30.2077 15.8432 29.7493 14.4176C29.5723 13.8793 29.3669 13.3508 29.1341 12.8342C32.1588 13.87 34.6919 15.9908 36.2433 18.7863ZM37.849 24.9986C37.8495 26.1076 37.7062 27.2119 37.4226 28.2841H31.0918C31.2553 26.0978 31.2554 23.9023 31.0919 21.716H37.4232C37.7064 22.7872 37.8495 23.8906 37.849 24.9986ZM12.1526 24.9986C12.1521 23.8906 12.2952 22.7872 12.5783 21.716H18.9095C18.7461 23.9023 18.7462 26.0978 18.9097 28.2841H12.5789C12.2953 27.2119 12.1521 26.1076 12.1526 24.9986ZM21.7168 24.9986C21.7168 23.8756 21.761 22.7759 21.8461 21.716H28.155C28.2401 22.7758 28.2843 23.8758 28.2843 24.9986C28.2843 26.1215 28.2401 27.2233 28.1549 28.2841H21.8465C21.7593 27.1911 21.7161 26.095 21.7168 24.9986ZM26.9683 15.3404C27.3315 16.4664 27.6084 17.6183 27.7966 18.7863H22.2048C22.3931 17.6183 22.6699 16.4663 23.0329 15.3403C23.9111 12.6928 24.8074 12.1517 24.9994 12.1517C25.1914 12.1517 26.0897 12.6929 26.9683 15.3404ZM20.8672 12.8337C20.6343 13.3505 20.4289 13.8792 20.2519 14.4177C19.7938 15.8433 19.455 17.3046 19.239 18.7863H13.758C15.3091 15.9905 17.8423 13.8694 20.8672 12.8337ZM13.7588 31.2137H19.2395C19.4554 32.6953 19.7941 34.1563 20.2522 35.5817C20.4292 36.1203 20.6346 36.6492 20.8674 37.1661C17.8429 36.1302 15.31 34.0093 13.7588 31.2137ZM23.0329 34.6593C22.67 33.5335 22.3932 32.3816 22.2049 31.2137H27.7965C27.6082 32.3816 27.3313 33.5334 26.9682 34.6593C26.0893 37.3069 25.1918 37.8481 24.9994 37.8481C24.807 37.8481 23.9111 37.3069 23.0329 34.6593ZM29.134 37.1656C29.3668 36.6489 29.5722 36.1202 29.7492 35.5818C30.2075 34.1564 30.5464 32.6953 30.7625 31.2137H36.2429C34.6914 34.009 32.1585 36.1297 29.134 37.1656ZM33.8117 46.0362C33.8743 46.2181 33.9005 46.4105 33.8887 46.6025C33.877 46.7946 33.8275 46.9824 33.7432 47.1553C33.6589 47.3282 33.5413 47.4827 33.3972 47.6102C33.2531 47.7377 33.0854 47.8355 32.9035 47.8981C27.7249 49.6848 22.0936 49.6634 16.9288 47.8372C11.7641 46.0111 7.37082 42.4881 4.46627 37.8434C1.56171 33.1986 0.317397 27.7065 0.936435 22.2635C1.55547 16.8204 4.0013 11.748 7.87467 7.87409C7.93991 7.80906 8.00612 7.74538 8.07194 7.68113H6.21706C5.82856 7.68113 5.45597 7.5268 5.18126 7.25208C4.90655 6.97737 4.75221 6.60478 4.75221 6.21628C4.75221 5.82778 4.90655 5.45519 5.18126 5.18048C5.45597 4.90577 5.82856 4.75144 6.21706 4.75144H11.6068C11.9953 4.75144 12.3679 4.90577 12.6426 5.18048C12.9173 5.45519 13.0716 5.82778 13.0716 6.21628V11.6032C13.0716 11.9917 12.9173 12.3643 12.6426 12.639C12.3679 12.9137 11.9953 13.068 11.6068 13.068C11.2183 13.068 10.8457 12.9137 10.571 12.639C10.2963 12.3643 10.142 11.9917 10.142 11.6032V9.75427C10.0759 9.81843 10.0098 9.8823 9.9446 9.94734C1.64606 18.2459 1.64606 31.7513 9.94626 40.0516C15.7519 45.8572 24.183 47.8025 31.9496 45.1281C32.3169 45.0016 32.7194 45.0262 33.0686 45.1965C33.4178 45.3668 33.685 45.6689 33.8115 46.0362H33.8117ZM42.127 42.1232C42.0611 42.189 41.9941 42.2537 41.9276 42.3185H43.7846C44.1731 42.3185 44.5457 42.4729 44.8204 42.7476C45.0951 43.0223 45.2495 43.3949 45.2495 43.7834C45.2495 44.1719 45.0951 44.5445 44.8204 44.8192C44.5457 45.0939 44.1731 45.2482 43.7846 45.2482H38.395C38.0065 45.2482 37.6339 45.0939 37.3592 44.8192C37.0845 44.5445 36.9301 44.1719 36.9301 43.7834V38.3937C36.9301 38.0052 37.0845 37.6326 37.3592 37.3579C37.6339 37.0832 38.0065 36.9289 38.395 36.9289C38.7835 36.9289 39.1561 37.0832 39.4308 37.3579C39.7055 37.6326 39.8598 38.0052 39.8598 38.3937V40.2432C39.9252 40.1795 39.9908 40.1163 40.0551 40.0513C48.3553 31.7511 48.3553 18.2457 40.0551 9.94548C34.2488 4.14216 25.8178 2.19783 18.0519 4.87185C17.8697 4.93581 17.6767 4.96312 17.4839 4.9522C17.2911 4.94129 17.1023 4.89235 16.9285 4.80822C16.7547 4.72409 16.5992 4.60643 16.4711 4.46199C16.3429 4.31756 16.2445 4.1492 16.1817 3.96662C16.1188 3.78403 16.0926 3.59082 16.1047 3.39809C16.1168 3.20536 16.1669 3.01692 16.252 2.84361C16.3372 2.6703 16.4558 2.51555 16.601 2.38824C16.7462 2.26094 16.9152 2.1636 17.0981 2.10183C22.2764 0.31474 27.9076 0.335835 33.0724 2.16167C38.2372 3.98751 42.6305 7.51024 45.5351 12.1548C48.4397 16.7993 49.6841 22.2913 49.0651 27.7343C48.446 33.1772 46.0002 38.2495 42.1268 42.1232H42.127Z"
                        fill="#112D55"
                      />
                      <path
                        d="M37.4229 21.716H31.0916C31.2551 23.9023 31.255 26.0978 31.0915 28.2841H37.4224C37.9907 26.1316 37.9909 23.8685 37.4229 21.716ZM29.7486 35.5818C29.5716 36.1202 29.3663 36.6489 29.1334 37.1656C32.1577 36.1296 34.6905 34.0089 36.2419 31.2137H30.7622C30.5461 32.6954 30.2071 34.1564 29.7486 35.5818ZM26.9681 15.3404C26.0892 12.6929 25.1915 12.1517 24.9991 12.1517C24.8067 12.1517 23.9108 12.6928 23.0326 15.3403C22.6696 16.4663 22.3928 17.6183 22.2045 18.7863H27.7964C27.6081 17.6183 27.3312 16.4664 26.9681 15.3404ZM18.7868 24.9986C18.7868 23.8817 18.8293 22.7832 18.9093 21.716H12.578C12.0103 23.8686 12.0105 26.1316 12.5786 28.2841H18.9095C18.8277 27.1908 18.7868 26.0949 18.7868 24.9986ZM30.7622 18.7863H36.2435C34.692 15.9908 32.1588 13.87 29.1341 12.8342C29.3669 13.3508 29.5723 13.8793 29.7493 14.4177C30.2076 15.8432 30.5464 17.3045 30.7622 18.7863ZM19.2393 31.2137H13.7585C15.3096 34.0092 17.8424 36.1301 20.8669 37.1661C20.634 36.6492 20.4286 36.1203 20.2517 35.5817C19.7937 34.1563 19.455 32.6953 19.2393 31.2137ZM21.8462 21.716C21.7611 22.7759 21.7169 23.8758 21.7169 24.9986C21.7169 26.1215 21.7611 27.2233 21.8463 28.2841H28.1548C28.2399 27.2233 28.2842 26.1224 28.2842 24.9986C28.2842 23.8748 28.2399 22.7758 28.1549 21.716H21.8462ZM23.0326 34.6594C23.9108 37.3069 24.8071 37.8481 24.9991 37.8481C25.1911 37.8481 26.0895 37.3069 26.968 34.6593C27.331 33.5334 27.6079 32.3816 27.7962 31.2137H22.2047C22.3929 32.3816 22.6697 33.5335 23.0326 34.6594ZM13.7577 18.7863H19.2388C19.4547 17.3046 19.7935 15.8433 20.2517 14.4177C20.4287 13.8792 20.634 13.3505 20.8669 12.8337C17.842 13.8694 15.3089 15.9905 13.7577 18.7863Z"
                        fill="#E6B22E"
                      />
                    </g>
                    <defs>
                      <clipPath id="clip0_10537_31">
                        <rect width={50} height={50} fill="white" />
                      </clipPath>
                    </defs>
                  </svg>
                </div>
                <div className="content">
                  <div className="title">Free Shipping</div>
                  <p>Free shipping over order $120</p>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div className="tf-icon-box text-center">
                <div className="icon">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width={60}
                    height={60}
                    viewBox="0 0 60 60"
                    fill="none"
                  >
                    <path
                      d="M32.5 31.2875L37.5 28.75H47.5L52.5 31.2875V37.8325C52.5061 40.7064 51.637 43.514 50.0083 45.8818C48.3796 48.2496 46.0685 50.0654 43.3825 51.0875H43.3775C42.8123 51.3026 42.1878 51.3026 41.6225 51.0875H41.6175C38.9319 50.064 36.6213 48.2476 34.9928 45.8796C33.3642 43.5115 32.4948 40.704 32.5 37.83V31.285V31.2875Z"
                      fill="#75AFFF"
                    />
                    <path
                      d="M32.5 31.2875L37.5 28.75H47.5L52.5 31.2875V37.8325C52.5061 40.7064 51.637 43.514 50.0083 45.8818C48.3796 48.2496 46.0685 50.0654 43.3825 51.0875H43.3775C42.8123 51.3026 42.1878 51.3026 41.6225 51.0875H41.6175C38.9319 50.064 36.6213 48.2476 34.9928 45.8796C33.3642 43.5115 32.4948 40.704 32.5 37.83V31.285V31.2875Z"
                      fill="#75AFFF"
                    />
                    <path
                      d="M28.7495 15.625H23.7495C23.2522 15.625 22.7753 15.4275 22.4236 15.0758C22.072 14.7242 21.8745 14.2473 21.8745 13.75C21.8745 13.2527 22.072 12.7758 22.4236 12.4242C22.7753 12.0725 23.2522 11.875 23.7495 11.875H28.7495C29.2467 11.875 29.7236 12.0725 30.0753 12.4242C30.4269 12.7758 30.6245 13.2527 30.6245 13.75C30.6245 14.2473 30.4269 14.7242 30.0753 15.0758C29.7236 15.4275 29.2467 15.625 28.7495 15.625ZM49.3745 31.2875V37.8325C49.3745 44.4775 45.2245 50.5075 39.047 52.84C38.0518 53.2183 36.9527 53.2192 35.957 52.8425C33.9439 52.0681 32.1118 50.8878 30.5745 49.375H17.502C15.679 49.3737 13.9311 48.6489 12.6421 47.3599C11.353 46.0709 10.6283 44.323 10.627 42.5V12.5C10.6283 10.677 11.353 8.92913 12.6421 7.6401C13.9311 6.35108 15.679 5.62632 17.502 5.625H35.002C36.8249 5.62632 38.5728 6.35108 39.8618 7.6401C41.1509 8.92913 41.8756 10.677 41.877 12.5V26.875H42.502C42.797 26.875 43.087 26.945 43.3495 27.0775L48.3495 29.615C48.6584 29.7718 48.9178 30.0111 49.0992 30.3063C49.2805 30.6015 49.3742 30.9411 49.3745 31.2875ZM17.4995 45.625H27.6945C26.3513 43.2465 25.6387 40.564 25.6245 37.8325V31.2875C25.6245 30.5825 26.022 29.935 26.652 29.615L31.652 27.0775C31.9147 26.9446 32.205 26.8752 32.4995 26.875H38.1245V12.5C38.1245 10.7775 36.722 9.375 34.9995 9.375H17.4995C15.777 9.375 14.3745 10.7775 14.3745 12.5V42.5C14.3745 44.2225 15.777 45.625 17.4995 45.625ZM45.6245 32.44L42.052 30.625H32.947L29.3745 32.44V37.8325C29.3745 42.925 32.552 47.5475 37.2795 49.335C37.4188 49.3876 37.5726 49.3876 37.712 49.335C42.4495 47.545 45.6245 42.925 45.6245 37.83V32.44ZM39.8495 34.9725L36.7495 38.4475L35.147 36.6525C34.8154 36.2815 34.3501 36.0574 33.8534 36.0296C33.3566 36.0017 32.8692 36.1722 32.4982 36.5037C32.1272 36.8353 31.9032 37.3006 31.8753 37.7973C31.8474 38.2941 32.0179 38.7815 32.3495 39.1525L35.3495 42.5125C35.526 42.7089 35.7419 42.8659 35.9831 42.9734C36.2243 43.0809 36.4854 43.1365 36.7495 43.1365C37.0135 43.1365 37.2746 43.0809 37.5158 42.9734C37.757 42.8659 37.9729 42.7089 38.1495 42.5125L42.6495 37.4725C42.9571 37.0982 43.1082 36.6194 43.071 36.1363C43.0339 35.6532 42.8114 35.2032 42.4501 34.8803C42.0889 34.5575 41.6167 34.3868 41.1325 34.404C40.6483 34.4211 40.1895 34.6248 39.852 34.9725H39.8495Z"
                      fill="#112D55"
                    />
                  </svg>
                </div>
                <div className="content">
                  <div className="title">Flexible Payment</div>
                  <p>Pay with Multiple Credit Cards</p>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div className="tf-icon-box text-center">
                <div className="icon">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width={50}
                    height={50}
                    viewBox="0 0 50 50"
                    fill="none"
                  >
                    <g clipPath="url(#clip0_10537_36)">
                      <path
                        d="M48.0469 27.1353C46.9683 27.1353 46.0939 26.2609 46.0939 25.1822C46.1169 6.33422 23.3906 -3.32543 10.2954 10.3264C9.54751 11.1034 8.31095 11.1271 7.53403 10.379C6.75691 9.63085 6.73338 8.39448 7.48149 7.61746C19.9378 -5.37232 41.1738 -1.05238 48.0534 15.4743C49.345 18.5686 50 21.8347 50 25.1821C50 26.2608 49.1256 27.1353 48.0469 27.1353ZM13.3805 15.9069C13.3805 14.8282 12.5061 13.9538 11.4274 13.9538H5.86125C4.78434 13.9538 3.90821 13.0777 3.90821 12.0008V6.4346C3.80508 3.8433 0.104365 3.84526 0.00212308 6.4346V12.0008C0.00212308 15.2315 2.63053 17.8599 5.86125 17.8599H11.4274C12.5061 17.8599 13.3805 16.9855 13.3805 15.9069ZM34.5792 47.9178C37.5645 46.6004 40.2364 44.7292 42.5206 42.3564C43.2687 41.5793 43.2452 40.3429 42.4681 39.5949C41.6913 38.8468 40.4545 38.8704 39.7067 39.6474C26.601 53.3052 3.88692 43.6359 3.9083 24.793C3.90821 23.7146 3.03383 22.8402 1.95516 22.8402C0.8765 22.8402 0.00212308 23.7147 0.00212308 24.7933C-0.179705 38.2254 11.3431 50.1838 24.8074 49.9859C28.1818 49.9859 31.4694 49.29 34.5792 47.9178ZM50 43.5408V37.9747C50 34.7439 47.3716 32.1155 44.1409 32.1155H38.5747C35.9834 32.2187 35.9853 35.9194 38.5747 36.0216H44.1409C45.2178 36.0216 46.0939 36.8977 46.0939 37.9747V43.5408C46.0939 44.6195 46.9683 45.4939 48.0469 45.4939C49.1256 45.4939 50 44.6195 50 43.5408Z"
                        fill="#112D55"
                      />
                      <path
                        d="M29.6888 35.1427H20.3142C16.5449 35.1427 13.4785 32.0762 13.4785 28.307V21.862C13.4785 18.0928 16.5449 15.0264 20.3142 15.0264H29.6888C33.458 15.0264 36.5244 18.0928 36.5244 21.862V28.307C36.5244 32.0762 33.4579 35.1427 29.6888 35.1427ZM20.3142 18.9324C18.6988 18.9324 17.3846 20.2467 17.3846 21.862V28.307C17.3846 29.9224 18.6988 31.2366 20.3142 31.2366H29.6888C31.3041 31.2366 32.6183 29.9224 32.6183 28.307V21.862C32.6183 20.2467 31.3041 18.9324 29.6888 18.9324H20.3142ZM28.5169 24.2057C28.5169 23.127 27.6426 22.2526 26.5639 22.2526H23.439C20.8477 22.3557 20.8497 26.0565 23.439 26.1587H26.5639C27.6426 26.1587 28.5169 25.2843 28.5169 24.2057Z"
                        fill="#FF5CF4"
                      />
                    </g>
                    <defs>
                      <clipPath id="clip0_10537_36">
                        <rect width={50} height={50} fill="white" />
                      </clipPath>
                    </defs>
                  </svg>
                </div>
                <div className="content">
                  <div className="title">14 Day Returns</div>
                  <p>Within 30 days for an exchange</p>
                </div>
              </div>
            </SwiperSlide>
            <SwiperSlide className="swiper-slide">
              <div className="tf-icon-box text-center">
                <div className="icon">
                  <svg
                    xmlns="http://www.w3.org/2000/svg"
                    width={60}
                    height={60}
                    viewBox="0 0 60 60"
                    fill="none"
                  >
                    <path
                      d="M32.5 31.2875L37.5 28.75H47.5L52.5 31.2875V37.8325C52.5061 40.7064 51.637 43.514 50.0083 45.8818C48.3796 48.2496 46.0685 50.0654 43.3825 51.0875H43.3775C42.8123 51.3026 42.1878 51.3026 41.6225 51.0875H41.6175C38.9319 50.064 36.6213 48.2476 34.9928 45.8796C33.3642 43.5115 32.4948 40.704 32.5 37.83V31.285V31.2875Z"
                      fill="#75AFFF"
                    />
                    <path
                      d="M32.5 31.2875L37.5 28.75H47.5L52.5 31.2875V37.8325C52.5061 40.7064 51.637 43.514 50.0083 45.8818C48.3796 48.2496 46.0685 50.0654 43.3825 51.0875H43.3775C42.8123 51.3026 42.1878 51.3026 41.6225 51.0875H41.6175C38.9319 50.064 36.6213 48.2476 34.9928 45.8796C33.3642 43.5115 32.4948 40.704 32.5 37.83V31.285V31.2875Z"
                      fill="#75AFFF"
                    />
                    <path
                      d="M28.7495 15.625H23.7495C23.2522 15.625 22.7753 15.4275 22.4236 15.0758C22.072 14.7242 21.8745 14.2473 21.8745 13.75C21.8745 13.2527 22.072 12.7758 22.4236 12.4242C22.7753 12.0725 23.2522 11.875 23.7495 11.875H28.7495C29.2467 11.875 29.7236 12.0725 30.0753 12.4242C30.4269 12.7758 30.6245 13.2527 30.6245 13.75C30.6245 14.2473 30.4269 14.7242 30.0753 15.0758C29.7236 15.4275 29.2467 15.625 28.7495 15.625ZM49.3745 31.2875V37.8325C49.3745 44.4775 45.2245 50.5075 39.047 52.84C38.0518 53.2183 36.9527 53.2192 35.957 52.8425C33.9439 52.0681 32.1118 50.8878 30.5745 49.375H17.502C15.679 49.3737 13.9311 48.6489 12.6421 47.3599C11.353 46.0709 10.6283 44.323 10.627 42.5V12.5C10.6283 10.677 11.353 8.92913 12.6421 7.6401C13.9311 6.35108 15.679 5.62632 17.502 5.625H35.002C36.8249 5.62632 38.5728 6.35108 39.8618 7.6401C41.1509 8.92913 41.8756 10.677 41.877 12.5V26.875H42.502C42.797 26.875 43.087 26.945 43.3495 27.0775L48.3495 29.615C48.6584 29.7718 48.9178 30.0111 49.0992 30.3063C49.2805 30.6015 49.3742 30.9411 49.3745 31.2875ZM17.4995 45.625H27.6945C26.3513 43.2465 25.6387 40.564 25.6245 37.8325V31.2875C25.6245 30.5825 26.022 29.935 26.652 29.615L31.652 27.0775C31.9147 26.9446 32.205 26.8752 32.4995 26.875H38.1245V12.5C38.1245 10.7775 36.722 9.375 34.9995 9.375H17.4995C15.777 9.375 14.3745 10.7775 14.3745 12.5V42.5C14.3745 44.2225 15.777 45.625 17.4995 45.625ZM45.6245 32.44L42.052 30.625H32.947L29.3745 32.44V37.8325C29.3745 42.925 32.552 47.5475 37.2795 49.335C37.4188 49.3876 37.5726 49.3876 37.712 49.335C42.4495 47.545 45.6245 42.925 45.6245 37.83V32.44ZM39.8495 34.9725L36.7495 38.4475L35.147 36.6525C34.8154 36.2815 34.3501 36.0574 33.8534 36.0296C33.3566 36.0017 32.8692 36.1722 32.4982 36.5037C32.1272 36.8353 31.9032 37.3006 31.8753 37.7973C31.8474 38.2941 32.0179 38.7815 32.3495 39.1525L35.3495 42.5125C35.526 42.7089 35.7419 42.8659 35.9831 42.9734C36.2243 43.0809 36.4854 43.1365 36.7495 43.1365C37.0135 43.1365 37.2746 43.0809 37.5158 42.9734C37.757 42.8659 37.9729 42.7089 38.1495 42.5125L42.6495 37.4725C42.9571 37.0982 43.1082 36.6194 43.071 36.1363C43.0339 35.6532 42.8114 35.2032 42.4501 34.8803C42.0889 34.5575 41.6167 34.3868 41.1325 34.404C40.6483 34.4211 40.1895 34.6248 39.852 34.9725H39.8495Z"
                      fill="#112D55"
                    />
                  </svg>
                </div>
                <div className="content">
                  <div className="title">Flexible Payment</div>
                  <p>Pay with Multiple Credit Cards</p>
                </div>
              </div>
            </SwiperSlide>
          </Swiper>
          <div className="sw-dots style-2 sw-pagination-mb justify-content-center spd200" />
        </div>
      </div>
    </section>
  );
}
