"use client";

import { useEffect, useState } from "react";

export default function Quantity({ setQuantity = (value) => {}, maxQuantity }) {
	const [count, setCount] = useState(1);

	useEffect(() => {
		setQuantity(count);
	}, [count]);

	const handleDecrease = () => {
		setCount((prev) => (prev > 1 ? prev - 1 : 1)); // Prevent going below 1
	};

	const handleIncrease = () => {
		setCount((prev) => (prev < maxQuantity ? prev + 1 : maxQuantity)); // Prevent going above maxQuantity
	};

	const handleInputChange = (e) => {
		let value = e.target.value / 1; // Convert to number
		if (value < 1) value = 1; // Prevent going below 1
		if (value > maxQuantity) value = maxQuantity; // Prevent going above maxQuantity
		setCount(value);
	};

	return (
		<div className="wg-quantity">
			<span className="btn-quantity minus-btn" onClick={handleDecrease}>
				-
			</span>
			<input
				min={1}
				type="text"
				onChange={handleInputChange}
				name="number"
				value={count}
			/>
			<span className="btn-quantity plus-btn" onClick={handleIncrease}>
				+
			</span>
		</div>
	);
}
