import { apiHandler, db } from '@/helpers/api';

export default apiHandler({
     post: editAvatar
});

async function editAvatar(req, res) {
     const userID = req.userID;
     const data = req.body; 

     if(!db.initialized)
          await db.initialize(); 

     try {
          const userData = await db.User.findByPk(userID); 
          
          if (!userData) 
               return res.status(404).json({ error: 'Unknown!' });

          await db.User.update(
               { avatar: data.documentLocation }, 
               { where: { id:userID } }
          );

          return res.status(200).json({ message: 'Felicitari! Avatarul a fost actualizat cu succes.' });
     } catch (error) {
          return res.status(500).json({ error: 'Unexpected Error!' });
     }
}